
/*
    wgms3d - a full-vectorial finite-difference mode solver.

    Copyright (C) 2005-2012  Michael Krause <m.krause@tu-harburg.de>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

 _stddiffop[4+NDO*k+(0+NSP*k)*(2*NDO)] = -0.8e1 * (e * n * n * w + e * e * n * n + w * w * n * n + e * e * n * s + w * w * s * n + e * n * w * s + e * s * s * w + e * e * s * s + w * w * s * s) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / n / s;

 _stddiffop[4+NDO*k+(1+NSP*k)*(2*NDO)] = 0.4e1 / 0.3e1 * (0.6e1 * e * n * n * w * s + 0.5e1 * w * w * pow(s, 0.3e1) + w * w * pow(n, 0.3e1) + 0.5e1 * e * e * pow(s, 0.3e1) + 0.6e1 * e * e * n * n * s + 0.2e1 * e * pow(n, 0.3e1) * w + 0.6e1 * e * s * s * w * n + 0.6e1 * w * w * s * s * n + 0.6e1 * w * w * n * n * s + 0.4e1 * e * pow(s, 0.3e1) * w + 0.6e1 * e * e * s * s * n + e * e * pow(n, 0.3e1)) / (s + n) / s / n / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s);

 _stddiffop[4+NDO*k+(2+NSP*k)*(2*NDO)] = -0.2e1 / 0.3e1 * (-0.5e1 * e * e * pow(s, 0.3e1) - 0.6e1 * w * w * pow(s, 0.3e1) - 0.5e1 * e * e * n * n * s + 0.2e1 * e * pow(n, 0.3e1) * w - 0.3e1 * e * n * n * w * s - 0.6e1 * e * s * s * w * n - 0.4e1 * w * w * s * s * n - 0.4e1 * w * w * n * n * s - 0.2e1 * e * e * s * s * n - 0.5e1 * e * pow(s, 0.3e1) * w + 0.2e1 * w * w * pow(n, 0.3e1)) / (s + n) / s / n / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s);

 _stddiffop[4+NDO*k+(3+NSP*k)*(2*NDO)] = -0.2e1 / 0.3e1 * (0.5e1 * e * e * n * n + 0.4e1 * w * w * n * n + 0.3e1 * e * n * n * w + 0.4e1 * w * w * s * n + 0.6e1 * e * n * w * s + 0.2e1 * e * e * n * s + 0.5e1 * e * e * s * s + 0.4e1 * w * w * s * s + 0.3e1 * e * s * s * w) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / n / s;

 _stddiffop[4+NDO*k+(4+NSP*k)*(2*NDO)] = 0.2e1 / 0.3e1 * (0.5e1 * e * e * pow(n, 0.3e1) - 0.2e1 * w * w * pow(s, 0.3e1) + 0.2e1 * e * e * n * n * s + 0.5e1 * e * pow(n, 0.3e1) * w + 0.4e1 * w * w * n * n * s + 0.6e1 * e * n * n * w * s + 0.3e1 * e * s * s * w * n + 0.4e1 * w * w * s * s * n + 0.5e1 * e * e * s * s * n - 0.2e1 * e * pow(s, 0.3e1) * w + 0.6e1 * w * w * pow(n, 0.3e1)) / (s + n) / s / n / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s);

 _stddiffop[4+NDO*k+(5+NSP*k)*(2*NDO)] = 0.4e1 / 0.3e1 * (w * w * pow(s, 0.3e1) + e * e * pow(s, 0.3e1) + 0.5e1 * e * e * pow(n, 0.3e1) + 0.6e1 * e * e * n * n * s + 0.4e1 * e * pow(n, 0.3e1) * w + 0.6e1 * e * n * n * w * s + 0.6e1 * e * s * s * w * n + 0.6e1 * w * w * s * s * n + 0.6e1 * w * w * n * n * s + 0.2e1 * e * pow(s, 0.3e1) * w + 0.6e1 * e * e * s * s * n + 0.5e1 * w * w * pow(n, 0.3e1)) / (s + n) / s / n / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s);

 _stddiffop[4+NDO*k+(6+NSP*k)*(2*NDO)] = 0.2e1 / 0.3e1 * (0.6e1 * e * n * n * w * s + 0.5e1 * w * w * pow(n, 0.3e1) + 0.6e1 * e * e * pow(n, 0.3e1) - 0.2e1 * e * e * pow(s, 0.3e1) + 0.5e1 * e * pow(n, 0.3e1) * w + 0.4e1 * e * e * n * n * s + 0.2e1 * w * w * n * n * s + 0.3e1 * e * s * s * w * n - 0.2e1 * e * pow(s, 0.3e1) * w + 0.4e1 * e * e * s * s * n + 0.5e1 * w * w * s * s * n) / (s + n) / s / n / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s);

 _stddiffop[4+NDO*k+(7+NSP*k)*(2*NDO)] = -0.2e1 / 0.3e1 * (0.5e1 * w * w * n * n + 0.3e1 * e * n * n * w + 0.4e1 * e * e * n * n + 0.6e1 * e * n * w * s + 0.4e1 * e * e * n * s + 0.2e1 * w * w * s * n + 0.4e1 * e * e * s * s + 0.5e1 * w * w * s * s + 0.3e1 * e * s * s * w) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / n / s;

 _stddiffop[4+NDO*k+(8+NSP*k)*(2*NDO)] = -0.2e1 / 0.3e1 * (-0.6e1 * e * e * pow(s, 0.3e1) + 0.2e1 * e * e * pow(n, 0.3e1) + 0.2e1 * e * pow(n, 0.3e1) * w - 0.4e1 * e * e * n * n * s - 0.5e1 * w * w * n * n * s - 0.6e1 * e * s * s * w * n - 0.3e1 * e * n * n * w * s - 0.5e1 * e * pow(s, 0.3e1) * w - 0.4e1 * e * e * s * s * n - 0.2e1 * w * w * s * s * n - 0.5e1 * w * w * pow(s, 0.3e1)) / (s + n) / s / n / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s);

 _stddiffop[0+NDO*k+(0+NSP*k)*(2*NDO)] = (0.4e1 * n * pow(e, 0.3e1) * s + 0.4e1 * n * n * pow(e, 0.3e1) + 0.4e1 * pow(e, 0.3e1) * s * s - e * e * s * s * w + 0.2e1 * e * e * n * s * w - e * e * n * n * w + e * w * w * s * s - 0.2e1 * e * w * w * s * n + e * w * w * n * n - 0.4e1 * n * n * pow(w, 0.3e1) - 0.4e1 * n * s * pow(w, 0.3e1) - 0.4e1 * pow(w, 0.3e1) * s * s) / w / e / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s);

 _stddiffop[0+NDO*k+(1+NSP*k)*(2*NDO)] = (0.3e1 * n * pow(e, 0.3e1) * s + 0.4e1 * pow(e, 0.3e1) * s * s + 0.5e1 * n * n * pow(e, 0.3e1) + e * e * n * n * w - e * e * s * s * w - e * w * w * n * n + e * w * w * s * s - 0.5e1 * n * n * pow(w, 0.3e1) - 0.4e1 * pow(w, 0.3e1) * s * s - 0.3e1 * n * s * pow(w, 0.3e1)) / w / e / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / 0.3e1;

 _stddiffop[0+NDO*k+(2+NSP*k)*(2*NDO)] = -(-0.2e1 * pow(e, 0.4e1) * s * s - 0.2e1 * n * pow(e, 0.4e1) * s - 0.6e1 * pow(w, 0.4e1) * s * s - n * n * pow(w, 0.3e1) * e - 0.4e1 * pow(e, 0.3e1) * s * s * w - 0.7e1 * pow(w, 0.3e1) * s * s * e + 0.5e1 * n * n * pow(e, 0.3e1) * w - 0.11e2 * e * e * s * s * w * w + n * n * e * e * w * w - 0.5e1 * n * pow(w, 0.4e1) * s - 0.5e1 * n * n * pow(w, 0.4e1) - 0.5e1 * n * pow(e, 0.3e1) * s * w - 0.8e1 * n * e * s * pow(w, 0.3e1) - 0.10e2 * n * e * e * s * w * w) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / e / w / (w + e) / 0.3e1;

 _stddiffop[0+NDO*k+(3+NSP*k)*(2*NDO)] = -(-0.8e1 * n * pow(w, 0.4e1) * s + 0.2e1 * pow(e, 0.4e1) * s * s - 0.10e2 * pow(w, 0.4e1) * s * s + 0.4e1 * n * pow(e, 0.4e1) * s - pow(e, 0.3e1) * s * s * w - 0.10e2 * pow(w, 0.3e1) * s * s * e - n * n * pow(e, 0.3e1) * w - 0.10e2 * n * n * pow(w, 0.3e1) * e - 0.11e2 * e * e * s * s * w * w - 0.11e2 * n * n * e * e * w * w + 0.2e1 * n * n * pow(e, 0.4e1) - 0.10e2 * n * n * pow(w, 0.4e1) - 0.8e1 * n * e * s * pow(w, 0.3e1) + 0.2e1 * n * e * e * s * w * w + 0.10e2 * n * pow(e, 0.3e1) * s * w) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / e / w / (w + e) / 0.3e1;

 _stddiffop[0+NDO*k+(4+NSP*k)*(2*NDO)] = (0.5e1 * n * pow(w, 0.4e1) * s + 0.7e1 * n * n * pow(w, 0.3e1) * e + 0.2e1 * n * pow(e, 0.4e1) * s + pow(w, 0.3e1) * s * s * e - 0.5e1 * pow(e, 0.3e1) * s * s * w + 0.4e1 * n * n * pow(e, 0.3e1) * w - e * e * s * s * w * w + 0.11e2 * n * n * e * e * w * w + 0.2e1 * n * n * pow(e, 0.4e1) + 0.6e1 * n * n * pow(w, 0.4e1) + 0.5e1 * pow(w, 0.4e1) * s * s + 0.10e2 * n * e * e * s * w * w + 0.5e1 * n * pow(e, 0.3e1) * s * w + 0.8e1 * n * e * s * pow(w, 0.3e1)) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / e / w / (w + e) / 0.3e1;

 _stddiffop[0+NDO*k+(5+NSP*k)*(2*NDO)] = (0.3e1 * n * pow(e, 0.3e1) * s + 0.5e1 * pow(e, 0.3e1) * s * s + 0.4e1 * n * n * pow(e, 0.3e1) + e * e * s * s * w - e * e * n * n * w - e * w * w * s * s + e * w * w * n * n - 0.3e1 * n * s * pow(w, 0.3e1) - 0.4e1 * n * n * pow(w, 0.3e1) - 0.5e1 * pow(w, 0.3e1) * s * s) / w / e / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / 0.3e1;

 _stddiffop[0+NDO*k+(6+NSP*k)*(2*NDO)] = -(0.5e1 * n * pow(e, 0.4e1) * s + 0.2e1 * n * pow(w, 0.4e1) * s + 0.5e1 * pow(e, 0.4e1) * s * s - 0.5e1 * pow(w, 0.3e1) * s * s * e + pow(e, 0.3e1) * s * s * w + 0.7e1 * n * n * pow(e, 0.3e1) * w + 0.4e1 * n * n * pow(w, 0.3e1) * e + 0.11e2 * n * n * e * e * w * w - e * e * s * s * w * w + 0.6e1 * n * n * pow(e, 0.4e1) + 0.2e1 * n * n * pow(w, 0.4e1) + 0.5e1 * n * e * s * pow(w, 0.3e1) + 0.10e2 * n * e * e * s * w * w + 0.8e1 * n * pow(e, 0.3e1) * s * w) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / e / w / (w + e) / 0.3e1;

 _stddiffop[0+NDO*k+(7+NSP*k)*(2*NDO)] = -(0.8e1 * n * pow(e, 0.4e1) * s - 0.4e1 * n * pow(w, 0.4e1) * s + 0.8e1 * n * pow(e, 0.3e1) * s * w - 0.2e1 * pow(w, 0.4e1) * s * s + 0.10e2 * pow(e, 0.4e1) * s * s + pow(w, 0.3e1) * s * s * e + 0.10e2 * pow(e, 0.3e1) * s * s * w + n * n * pow(w, 0.3e1) * e + 0.10e2 * n * n * pow(e, 0.3e1) * w + 0.11e2 * e * e * s * s * w * w + 0.11e2 * n * n * e * e * w * w - 0.2e1 * n * n * pow(w, 0.4e1) + 0.10e2 * n * n * pow(e, 0.4e1) - 0.10e2 * n * e * s * pow(w, 0.3e1) - 0.2e1 * n * e * e * s * w * w) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / e / w / (w + e) / 0.3e1;

 _stddiffop[0+NDO*k+(8+NSP*k)*(2*NDO)] = -(0.2e1 * n * pow(w, 0.4e1) * s + 0.11e2 * e * e * s * s * w * w + 0.6e1 * pow(e, 0.4e1) * s * s + 0.2e1 * pow(w, 0.4e1) * s * s + 0.7e1 * pow(e, 0.3e1) * s * s * w + 0.4e1 * pow(w, 0.3e1) * s * s * e + n * n * pow(e, 0.3e1) * w + 0.8e1 * n * pow(e, 0.3e1) * s * w - n * n * e * e * w * w - 0.5e1 * n * n * pow(w, 0.3e1) * e + 0.5e1 * n * pow(e, 0.4e1) * s + 0.5e1 * n * n * pow(e, 0.4e1) + 0.5e1 * n * e * s * pow(w, 0.3e1) + 0.10e2 * n * e * e * s * w * w) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / e / w / (w + e) / 0.3e1;

 _stddiffop[1+NDO*k+(0+NSP*k)*(2*NDO)] = (0.4e1 * pow(n, 0.3e1) * w * w + 0.4e1 * pow(n, 0.3e1) * e * e + 0.4e1 * pow(n, 0.3e1) * e * w - n * n * w * w * s - n * n * e * e * s + 0.2e1 * n * n * e * w * s + n * w * w * s * s + n * e * e * s * s - 0.2e1 * n * e * s * s * w - 0.4e1 * w * w * pow(s, 0.3e1) - 0.4e1 * e * pow(s, 0.3e1) * w - 0.4e1 * e * e * pow(s, 0.3e1)) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / n / s;

 _stddiffop[1+NDO*k+(1+NSP*k)*(2*NDO)] = -(-0.10e2 * w * w * pow(s, 0.4e1) + 0.2e1 * pow(n, 0.4e1) * w * w - 0.10e2 * e * e * pow(s, 0.4e1) + 0.2e1 * pow(n, 0.4e1) * e * e + 0.10e2 * e * pow(n, 0.3e1) * w * s - 0.10e2 * w * w * pow(s, 0.3e1) * n - w * w * pow(n, 0.3e1) * s - 0.10e2 * e * e * pow(s, 0.3e1) * n - e * e * pow(n, 0.3e1) * s + 0.2e1 * e * n * n * s * s * w - 0.8e1 * e * pow(s, 0.3e1) * w * n - 0.11e2 * w * w * n * n * s * s - 0.8e1 * e * pow(s, 0.4e1) * w - 0.11e2 * e * e * n * n * s * s + 0.4e1 * pow(n, 0.4e1) * e * w) / (s + n) / s / n / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / 0.3e1;

 _stddiffop[1+NDO*k+(2+NSP*k)*(2*NDO)] = (0.5e1 * e * e * pow(s, 0.4e1) + 0.6e1 * w * w * pow(s, 0.4e1) + 0.4e1 * w * w * pow(n, 0.3e1) * s - 0.5e1 * e * e * pow(n, 0.3e1) * s + 0.8e1 * e * pow(s, 0.3e1) * w * n + 0.2e1 * pow(n, 0.4e1) * w * w + 0.2e1 * pow(n, 0.4e1) * e * w + e * e * pow(s, 0.3e1) * n + 0.7e1 * w * w * pow(s, 0.3e1) * n + 0.5e1 * e * pow(n, 0.3e1) * w * s + 0.10e2 * e * n * n * s * s * w + 0.11e2 * w * w * n * n * s * s + 0.5e1 * e * pow(s, 0.4e1) * w - e * e * n * n * s * s) / (s + n) / s / n / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / 0.3e1;

 _stddiffop[1+NDO*k+(3+NSP*k)*(2*NDO)] = (0.5e1 * pow(n, 0.3e1) * e * e + 0.4e1 * pow(n, 0.3e1) * w * w + 0.3e1 * pow(n, 0.3e1) * e * w - n * n * w * w * s + n * n * e * e * s + n * w * w * s * s - n * e * e * s * s - 0.5e1 * e * e * pow(s, 0.3e1) - 0.3e1 * e * pow(s, 0.3e1) * w - 0.4e1 * w * w * pow(s, 0.3e1)) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / n / s / 0.3e1;

 _stddiffop[1+NDO*k+(4+NSP*k)*(2*NDO)] = -(0.2e1 * w * w * pow(s, 0.4e1) + 0.5e1 * pow(n, 0.4e1) * e * e - 0.5e1 * e * e * pow(s, 0.3e1) * n + 0.7e1 * w * w * pow(n, 0.3e1) * s + 0.6e1 * pow(n, 0.4e1) * w * w + 0.4e1 * w * w * pow(s, 0.3e1) * n + e * e * pow(n, 0.3e1) * s + 0.11e2 * w * w * n * n * s * s + 0.10e2 * e * n * n * s * s * w + 0.8e1 * e * pow(n, 0.3e1) * w * s + 0.5e1 * e * pow(s, 0.3e1) * w * n + 0.2e1 * e * pow(s, 0.4e1) * w - e * e * n * n * s * s + 0.5e1 * pow(n, 0.4e1) * e * w) / (s + n) / s / n / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / 0.3e1;

 _stddiffop[1+NDO*k+(5+NSP*k)*(2*NDO)] = -(-0.2e1 * e * e * pow(s, 0.4e1) + 0.10e2 * pow(n, 0.4e1) * e * e - 0.2e1 * w * w * pow(s, 0.4e1) + 0.10e2 * w * w * pow(n, 0.3e1) * s + 0.8e1 * e * pow(n, 0.3e1) * w * s + 0.10e2 * pow(n, 0.4e1) * w * w + e * e * pow(s, 0.3e1) * n + 0.10e2 * e * e * pow(n, 0.3e1) * s + w * w * pow(s, 0.3e1) * n + 0.11e2 * w * w * n * n * s * s - 0.2e1 * e * n * n * s * s * w - 0.10e2 * e * pow(s, 0.3e1) * w * n - 0.4e1 * e * pow(s, 0.4e1) * w + 0.11e2 * e * e * n * n * s * s + 0.8e1 * pow(n, 0.4e1) * e * w) / (s + n) / s / n / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / 0.3e1;

 _stddiffop[1+NDO*k+(6+NSP*k)*(2*NDO)] = -(0.6e1 * pow(n, 0.4e1) * e * e + 0.2e1 * e * e * pow(s, 0.4e1) + 0.5e1 * pow(n, 0.4e1) * w * w + 0.5e1 * e * pow(s, 0.3e1) * w * n - w * w * n * n * s * s + 0.7e1 * e * e * pow(n, 0.3e1) * s + 0.4e1 * e * e * pow(s, 0.3e1) * n + w * w * pow(n, 0.3e1) * s - 0.5e1 * w * w * pow(s, 0.3e1) * n + 0.10e2 * e * n * n * s * s * w + 0.8e1 * e * pow(n, 0.3e1) * w * s + 0.2e1 * e * pow(s, 0.4e1) * w + 0.5e1 * pow(n, 0.4e1) * e * w + 0.11e2 * e * e * n * n * s * s) / (s + n) / s / n / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / 0.3e1;

 _stddiffop[1+NDO*k+(7+NSP*k)*(2*NDO)] = (0.5e1 * pow(n, 0.3e1) * w * w + 0.4e1 * pow(n, 0.3e1) * e * e + 0.3e1 * pow(n, 0.3e1) * e * w + n * n * w * w * s - n * n * e * e * s - n * w * w * s * s + n * e * e * s * s - 0.4e1 * e * e * pow(s, 0.3e1) - 0.3e1 * e * pow(s, 0.3e1) * w - 0.5e1 * w * w * pow(s, 0.3e1)) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / n / s / 0.3e1;

 _stddiffop[1+NDO*k+(8+NSP*k)*(2*NDO)] = (0.2e1 * pow(n, 0.4e1) * e * e + 0.6e1 * e * e * pow(s, 0.4e1) + 0.8e1 * e * pow(s, 0.3e1) * w * n + 0.5e1 * w * w * pow(s, 0.4e1) - w * w * n * n * s * s + 0.4e1 * e * e * pow(n, 0.3e1) * s - 0.5e1 * w * w * pow(n, 0.3e1) * s + 0.7e1 * e * e * pow(s, 0.3e1) * n + w * w * pow(s, 0.3e1) * n + 0.10e2 * e * n * n * s * s * w + 0.5e1 * e * pow(n, 0.3e1) * w * s + 0.5e1 * e * pow(s, 0.4e1) * w + 0.2e1 * pow(n, 0.4e1) * e * w + 0.11e2 * e * e * n * n * s * s) / (s + n) / s / n / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / 0.3e1;

 _stddiffop[2+NDO*k+(0+NSP*k)*(2*NDO)] = -0.8e1 * (e * e * n * s + e * e * n * n + e * e * s * s + e * s * s * w + e * n * w * s + e * n * n * w + w * w * s * n + w * w * s * s + w * w * n * n) / w / e / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s);

 _stddiffop[2+NDO*k+(1+NSP*k)*(2*NDO)] = -0.2e1 / 0.3e1 * (0.4e1 * e * e * s * s + 0.5e1 * e * e * n * n + 0.3e1 * e * e * n * s + 0.2e1 * e * n * n * w + 0.4e1 * e * s * s * w + 0.6e1 * e * n * w * s + 0.3e1 * w * w * s * n + 0.4e1 * w * w * s * s + 0.5e1 * w * w * n * n) / w / e / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s);

 _stddiffop[2+NDO*k+(2+NSP*k)*(2*NDO)] = 0.2e1 / 0.3e1 * (-0.2e1 * n * pow(e, 0.3e1) * s + 0.6e1 * n * e * s * w * w + 0.5e1 * n * pow(w, 0.3e1) * s + 0.4e1 * e * e * s * s * w + 0.5e1 * n * n * e * e * w + 0.4e1 * e * w * w * s * s + 0.2e1 * n * n * e * w * w + 0.3e1 * n * e * e * s * w + 0.5e1 * n * n * pow(w, 0.3e1) - 0.2e1 * pow(e, 0.3e1) * s * s + 0.6e1 * pow(w, 0.3e1) * s * s) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / e / w / (w + e);

 _stddiffop[2+NDO*k+(3+NSP*k)*(2*NDO)] = 0.4e1 / 0.3e1 * (0.6e1 * e * w * w * s * s + 0.6e1 * n * n * e * w * w + 0.6e1 * e * e * s * s * w + 0.6e1 * n * n * e * e * w + 0.4e1 * n * pow(w, 0.3e1) * s + 0.2e1 * n * pow(e, 0.3e1) * s + 0.6e1 * n * e * s * w * w + n * n * pow(e, 0.3e1) + 0.5e1 * n * n * pow(w, 0.3e1) + pow(e, 0.3e1) * s * s + 0.5e1 * pow(w, 0.3e1) * s * s + 0.6e1 * n * e * e * s * w) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / e / w / (w + e);

 _stddiffop[2+NDO*k+(4+NSP*k)*(2*NDO)] = -0.2e1 / 0.3e1 * (-0.5e1 * e * e * s * s * w - 0.4e1 * n * n * e * e * w - 0.4e1 * n * n * e * w * w - 0.5e1 * n * pow(w, 0.3e1) * s + 0.2e1 * n * pow(e, 0.3e1) * s + 0.2e1 * n * n * pow(e, 0.3e1) - 0.6e1 * n * n * pow(w, 0.3e1) - 0.5e1 * pow(w, 0.3e1) * s * s - 0.2e1 * e * w * w * s * s - 0.3e1 * n * e * e * s * w - 0.6e1 * n * e * s * w * w) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / e / w / (w + e);

 _stddiffop[2+NDO*k+(5+NSP*k)*(2*NDO)] = -0.2e1 / 0.3e1 * (0.3e1 * e * e * n * s + 0.5e1 * e * e * s * s + 0.4e1 * e * e * n * n + 0.2e1 * e * s * s * w + 0.4e1 * e * n * n * w + 0.6e1 * e * n * w * s + 0.3e1 * w * w * s * n + 0.5e1 * w * w * s * s + 0.4e1 * w * w * n * n) / w / e / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s);

 _stddiffop[2+NDO*k+(6+NSP*k)*(2*NDO)] = 0.2e1 / 0.3e1 * (0.4e1 * n * n * e * e * w + 0.3e1 * n * e * s * w * w + 0.6e1 * n * e * e * s * w + 0.2e1 * e * e * s * s * w + 0.5e1 * e * w * w * s * s + 0.4e1 * n * n * e * w * w + 0.5e1 * n * pow(e, 0.3e1) * s + 0.6e1 * n * n * pow(e, 0.3e1) - 0.2e1 * n * n * pow(w, 0.3e1) - 0.2e1 * n * pow(w, 0.3e1) * s + 0.5e1 * pow(e, 0.3e1) * s * s) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / e / w / (w + e);

 _stddiffop[2+NDO*k+(7+NSP*k)*(2*NDO)] = 0.4e1 / 0.3e1 * (0.6e1 * e * e * s * s * w + 0.6e1 * n * n * e * e * w + 0.6e1 * n * n * e * w * w + 0.6e1 * e * w * w * s * s + 0.4e1 * n * pow(e, 0.3e1) * s + n * n * pow(w, 0.3e1) + 0.5e1 * n * n * pow(e, 0.3e1) + pow(w, 0.3e1) * s * s + 0.2e1 * n * pow(w, 0.3e1) * s + 0.6e1 * n * e * s * w * w + 0.6e1 * n * e * e * s * w + 0.5e1 * pow(e, 0.3e1) * s * s) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / e / w / (w + e);

 _stddiffop[2+NDO*k+(8+NSP*k)*(2*NDO)] = 0.2e1 / 0.3e1 * (0.3e1 * n * e * s * w * w + 0.5e1 * n * pow(e, 0.3e1) * s + 0.5e1 * n * n * e * w * w + 0.2e1 * n * n * e * e * w + 0.4e1 * e * e * s * s * w + 0.4e1 * e * w * w * s * s - 0.2e1 * n * pow(w, 0.3e1) * s + 0.5e1 * n * n * pow(e, 0.3e1) + 0.6e1 * pow(e, 0.3e1) * s * s + 0.6e1 * n * e * e * s * w - 0.2e1 * pow(w, 0.3e1) * s * s) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s) / e / w / (w + e);

 _stddiffop[3+NDO*k+(0+NSP*k)*(2*NDO)] = 0.3e1 * (n * e - n * w - e * s + s * w) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s);

 _stddiffop[3+NDO*k+(1+NSP*k)*(2*NDO)] = -(e * s - s * w + 0.4e1 * n * e - 0.4e1 * n * w) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s);

 _stddiffop[3+NDO*k+(2+NSP*k)*(2*NDO)] = (0.3e1 * n * w + 0.3e1 * e * s + 0.7e1 * n * e + 0.2e1 * s * w) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s);

 _stddiffop[3+NDO*k+(3+NSP*k)*(2*NDO)] = -(n * w + 0.4e1 * n * e - 0.4e1 * e * s - s * w) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s);

 _stddiffop[3+NDO*k+(4+NSP*k)*(2*NDO)] = -(0.2e1 * n * w + 0.3e1 * n * e + 0.7e1 * e * s + 0.3e1 * s * w) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s);

 _stddiffop[3+NDO*k+(5+NSP*k)*(2*NDO)] = (-n * w + n * e + 0.4e1 * e * s - 0.4e1 * s * w) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s);

 _stddiffop[3+NDO*k+(6+NSP*k)*(2*NDO)] = (0.2e1 * n * e + 0.7e1 * s * w + 0.3e1 * n * w + 0.3e1 * e * s) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s);

 _stddiffop[3+NDO*k+(7+NSP*k)*(2*NDO)] = (n * e + 0.4e1 * n * w - 0.4e1 * s * w - e * s) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s);

 _stddiffop[3+NDO*k+(8+NSP*k)*(2*NDO)] = -(0.2e1 * e * s + 0.3e1 * n * e + 0.3e1 * s * w + 0.7e1 * n * w) / (0.7e1 * w * w * n * n + 0.6e1 * e * n * n * w + 0.6e1 * e * e * n * s + 0.7e1 * w * w * s * s + 0.6e1 * e * s * s * w + 0.7e1 * e * e * s * s + 0.6e1 * w * w * s * n + 0.7e1 * e * e * n * n + 0.8e1 * e * n * w * s);

